/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.monitor;

import filenet.pa.admin.PAStatisticsSnapShot;
import filenet.pa.main.DTSStatisticsSnapShot;
import filenet.pa.publisher.PublisherStatisticsSnapShot;
import filenet.pa.sql.ExposedField;
import filenet.pa.sql.UDFMetaData;
import filenet.vw.api.VWFieldType;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.pa.PANode;
import filenet.vw.apps.taskman.pa.monitor.PAStatisticFormatter;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JFileChooser;

public class PADiagnosticFile {
    private PANode m_paNode = null;
    private PrintWriter m_writer = null;
    private int m_fieldWidth = 50;
    private PAStatisticFormatter m_formatter = new PAStatisticFormatter();
    private static final String DEFAULT_FILE_NAME = "padiagnostic.txt";

    public PADiagnosticFile(PANode paNode) {
        this.m_paNode = paNode;
    }

    public void write() throws Exception {
        this.m_writer = this.getWriter();
        if (this.m_writer == null) {
            return;
        }
        this.printStatistics();
        this.printTableSizes();
        this.printSystemConfiguration();
        this.printUDFConfiguration();
        this.m_writer.close();
    }

    private void printStatistics() {
        this.setFieldWidth(50);
        this.printHeading("Statistics");
        try {
            PAStatisticsSnapShot stats = this.m_paNode.getPAAdministration().getStatistics();
            PublisherStatisticsSnapShot pubStats = stats.getPublisherStats();
            DTSStatisticsSnapShot dtsStats = stats.getDTSStats();
            this.printSubHeading("Cache");
            this.printPercentage("Dimension Cache Hit Rate", pubStats.getDimensionCacheHitRate());
            this.printPercentage("Fact Table Cache Hit Rate", pubStats.getFactCacheHitRate());
            this.printSubHeading("Data Publishing");
            this.print("Events published (Process Engine)", pubStats.getPEEventsPublishedSinceReset());
            this.print("Events published (Content Engine)", pubStats.getCEEventsPublishedSinceReset());
            this.print("Average events published /sec", pubStats.getAvgEventsPublishedPerSec());
            this.printSubHeading("Database Operations");
            this.print("Average database update time (sec)", pubStats.getAvgDatabaseUpdateTimeInSec());
            this.print("Average database updates per interval", pubStats.getAvgDatabaseUpdatesPerInterval());
            this.print("Average cube processing time (sec)", dtsStats.getAvgCubeProcessingTimeInSec());
            this.print("Average Publishing Interval Cube Processing Time (Sec)", dtsStats.getAvgWIPCubeProcessingTimeInSec());
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    private void printSystemConfiguration() {
        this.setFieldWidth(50);
        this.printHeading("System Configuration");
        try {
            Properties props = this.m_paNode.getPAProperties();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                this.print(propName, props.getProperty(propName, ""));
            }
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    private void printUDFConfiguration() {
        this.setFieldWidth(20);
        this.printHeading("UDF Configuration");
        try {
            ExposedField[] fields = this.m_paNode.getExposedDataFields();
            for (int i = 0; i < fields.length; ++i) {
                this.printSubHeading(fields[i].getUniqueName());
                this.print("Field Name", fields[i].get_FieldName());
                this.print("Field Type", VWFieldType.getLocalizedString(fields[i].getType().getOrdinal()));
                this.print("Type", fields[i].isMeasure() ? "Measure" : "Dimension");
                this.print("Cubes", this.cubesToString(fields[i].getCubes().toArray()));
                this.print("Cube Options", fields[i].getCubeOptions());
                this.print("Ranges", this.rangesToString(fields[i].getRanges()));
            }
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    private void printTableSizes() {
        this.setFieldWidth(50);
        this.printHeading("Database Table Sizes");
        try {
            HashMap tableMap = this.m_paNode.getPAAdministration().getTableSizes();
            for (String tableName : tableMap.keySet()) {
                this.print(tableName, (Long)tableMap.get(tableName));
            }
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    private String cubesToString(Object[] cubeTypes) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < cubeTypes.length; ++i) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(((UDFMetaData.CubeType)cubeTypes[i]).getName());
        }
        buffer.insert(0, "{");
        buffer.append("}");
        return buffer.toString();
    }

    private String rangesToString(Collection theRanges) {
        StringBuffer buffer = new StringBuffer();
        if (theRanges != null) {
            Object[] ranges = theRanges.toArray();
            for (int i = 0; i < ranges.length; ++i) {
                if (ranges[i] == null) continue;
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(ranges[i].toString());
            }
            buffer.insert(0, "{");
            buffer.append("}");
        }
        return buffer.toString();
    }

    private void printHeading(String header) {
        this.m_writer.println("");
        this.m_writer.println("===============================================================================");
        this.m_writer.println(header.toUpperCase());
        this.m_writer.println("===============================================================================");
    }

    private void printSubHeading(String header) {
        this.m_writer.println("");
        this.m_writer.println("===========================================");
        this.m_writer.println(header);
        this.m_writer.println("===========================================");
    }

    private void print(String name, String value) {
        this.m_writer.println(this.padString(name) + "    " + value);
    }

    private void print(String name, long value) {
        this.print(name, this.m_formatter.formatLong(value));
    }

    private void print(String name, float value) {
        this.print(name, this.m_formatter.formatFloat(value));
    }

    private void printPercentage(String name, float value) {
        this.print(name, this.m_formatter.formatPercentage(value));
    }

    private void printException(Exception ex) {
        this.m_writer.println("Unexpected exception: " + ex.getLocalizedMessage());
        ex.printStackTrace(this.m_writer);
    }

    private void setFieldWidth(int width) {
        this.m_fieldWidth = width;
    }

    private String padString(String string) {
        StringBuffer buffer = new StringBuffer(string);
        buffer.ensureCapacity(this.m_fieldWidth);
        for (int i = buffer.length(); i < this.m_fieldWidth; ++i) {
            buffer.append(" ");
        }
        return buffer.toString();
    }

    private PrintWriter getWriter() throws Exception {
        JFileChooser dlg = new JFileChooser(this.m_paNode.getInstallDirectory());
        dlg.setFileSelectionMode(0);
        dlg.setMultiSelectionEnabled(false);
        dlg.setApproveButtonText(VWResource.Save);
        dlg.setDialogTitle(VWResource.SaveAs);
        dlg.setSelectedFile(new File(DEFAULT_FILE_NAME));
        PrintWriter writer = null;
        if (dlg.showOpenDialog(VWTaskCore.getInstance().getMainFrame()) == 0) {
            File file = dlg.getSelectedFile();
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "US-ASCII")));
        }
        return writer;
    }
}

